import numpy as np
import pandas as pd
import os


def gen_gaussian_noise(signal,SNR,seed):
    """
    :param signal: origin signal
    :param SNR: Signal-to-noise ratio with added noise
    :param seed: seed to reproduce the experiment
    :return: generated noise
    """
    np.random.seed(seed)
    noise = np.random.randn(*signal.shape) # *signal.shape size of the samples
    noise = noise-np.mean(noise)
    signal_power = (1/signal.shape[0]) * np.sum(np.power(signal,2))
    noise_variance=signal_power/np.power(10,(SNR/10))
    noise=(np.sqrt(noise_variance)/np.std(noise))*noise
    return noise



def check_snr(signal,noise):
    """
    :param signal: origin signal
    :param noise: Generated Gaussian noise
    :return: Return the signal-to-noise ratio
    """
    signal_power=(1/signal.shape[0])*np.sum(np.power(signal,2))# 0.5722037
    noise_power=(1/noise.shape[0])*np.sum(np.power(noise,2)) # 0.90688
    SNR=10*np.log10(signal_power/noise_power)
    return SNR